/*
 * Decompiled with CFR 0.152.
 */
package net.jayjay.dangerzone.mods;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.jayjay.dangerzone.client.DZ2;
import net.jayjay.dangerzone.mods.BaseMod;

public class ModLoader {
    private static final String MODS_DIR = "mods";
    private static final String MAIN_CLASS_SUFFIX = "Main";
    private static List<BaseMod> mods = new ArrayList<BaseMod>();

    public static void addManually(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            if (!BaseMod.class.isAssignableFrom(clazz)) {
                System.err.println(String.valueOf(className) + " does not extend BaseMod");
                return;
            }
            BaseMod mod = (BaseMod)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            mods.add(mod);
            System.out.println("Loaded mod: " + className);
        }
        catch (ClassNotFoundException e2) {
            System.err.println("Class not found on classpath: " + className);
        }
        catch (Exception e3) {
            System.err.println("Failed to instantiate " + className);
            e3.printStackTrace();
        }
    }

    public static void loadMods() throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        File modsDir = new File(MODS_DIR);
        if (!modsDir.exists()) {
            modsDir.mkdirs();
            System.out.println("Created mods directory: " + modsDir.getAbsolutePath());
            return;
        }
        File[] jarFiles = modsDir.listFiles((dir, name) -> name.toLowerCase().endsWith(".jar"));
        if (jarFiles == null || jarFiles.length == 0) {
            System.out.println("No mod JARs found in " + modsDir.getAbsolutePath());
            return;
        }
        File[] fileArray = jarFiles;
        int n = jarFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File jarFile = fileArray[n2];
            Throwable throwable = null;
            Object var7_8 = null;
            try (JarFile jar = new JarFile(jarFile);){
                URL jarURL = jarFile.toURI().toURL();
                Throwable throwable2 = null;
                Object var11_14 = null;
                try (URLClassLoader classLoader = new URLClassLoader(new URL[]{jarURL}, ModLoader.class.getClassLoader());){
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        String className;
                        JarEntry entry = entries.nextElement();
                        if (!entry.getName().endsWith(".class") || !(className = entry.getName().replace("/", ".").replace(".class", "")).endsWith(MAIN_CLASS_SUFFIX)) continue;
                        try {
                            Class<?> clazz = classLoader.loadClass(className);
                            if (!BaseMod.class.isAssignableFrom(clazz)) continue;
                            BaseMod mod = (BaseMod)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            mods.add(mod);
                            System.out.println("Loaded mod: " + className);
                        }
                        catch (Exception e2) {
                            System.err.println("Failed to load class " + className + ": " + e2.getMessage());
                        }
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
            ++n2;
        }
    }

    public static void runInits() {
        for (BaseMod mod : mods) {
            try {
                if (mod.versionBuiltWith().equals(DZ2.version)) {
                    mod.preInit();
                    continue;
                }
                System.err.println("This mod is out of date!\nMod is made for version " + mod.versionBuiltWith() + ", but we are running version " + DZ2.version);
            }
            catch (Exception e2) {
                System.err.println("Error in preInit for " + mod.getClass().getSimpleName() + ": " + e2.getMessage());
                e2.printStackTrace();
            }
        }
        for (BaseMod mod : mods) {
            try {
                mod.init();
            }
            catch (Exception e3) {
                System.err.println("Error in init for " + mod.getClass().getSimpleName() + ": " + e3.getMessage());
                e3.printStackTrace();
            }
        }
        for (BaseMod mod : mods) {
            try {
                mod.postInit();
            }
            catch (Exception e4) {
                System.err.println("Error in postInit for " + mod.getClass().getSimpleName() + ": " + e4.getMessage());
                e4.printStackTrace();
            }
        }
    }
}

